<?php

namespace VM\ApiBundle\Services;

use Symfony\Bundle\AsseticBundle\DependencyInjection\Configuration;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use \BaseFacebook;
use \FacebookApiException;

use Symfony\Component\Config\Definition\Processor;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;

class FacebookManager extends \Facebook
{
    /**
     * @var ContainerInterface
     */
    protected $container;

    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;

        $config = array(
            'appId' => $this->container->getParameter('facebook_appId'),
            'secret' => $this->container->getParameter('facebook_secret'),
        );

        parent::__construct($config);
    }

    public function getLoginUrl($params = array())
    {
        $params = array_merge($params,array('scope' => 'email, user_birthday'));
        return parent::getLoginUrl($params);
    }
}